///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  Copyright  NetworkDLS 2002, All rights reserved
//
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF 
// ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO 
// THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A 
// PARTICULAR PURPOSE.
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef _ENTRY_CPP
#define _ENTRY_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <Stdio.H>
#include <Stdlib.H>

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "../Resources/Resource.H"

#include "../../SharedSource/Debug.H"
#include "../../SharedSource/NSWFL.H"
#include "../../SharedSource/Common.H"

#include "../../SharedClasses/CMemPool/CMemPool.H"

#include "Entry.H"
#include "Init.H"
#include "WinService.H"
#include "Routines.H"
#include "Console.H"

#include "../CSockSrvr/CSockSrvr.H"

#include "../Dialogs/MainDlg.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

HINSTANCE ghAppInstance = NULL;

char gsAppCopyRight[64];
char gsFileVersion[32];
char gsTitleCaption[64];
char gsRegistryKey[255];
char gsEventName[255];

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevious, LPSTR sCmdLine, int iCmdShow)
{
	int iReturnVal = 0;
	
	ghAppInstance = hInstance;

	gServer.cbActive = false;
	
	if(IsWinNT() != true)
	{
		MessageBox(
			NULL,
			"This application was designed to run only on NT based systems.",
			"SQL Exchange",
			MB_ICONASTERISK | MB_SYSTEMMODAL | MB_TASKMODAL
		);
		return 2;
	}

	gbExcludeInit = ExcludedFromInit(sCmdLine);

	if(!InitializeApp())
    {
        return 1;
    }

	/*
	if(DoesServerFileExist("C:\\Program Files\\"))
	{
		MsgBox("Yes!");
	}
	else{
		MsgBox("NO!");
	}
	*/

	if(strlen(sCmdLine) > 0)
	{
		iReturnVal = ProcessCommandLine(sCmdLine);
	}
	else{
		iReturnVal = StartRoutine("/NonService");
	}

	if(!UninitializeApp())
    {
        return 1;
    }

	return iReturnVal;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int ProcessCommandLine(char *sCmdLine)
{
	if( _strcmpi(sCmdLine, "/NonService") == 0)
	{
		if(IsApplicationRunning())
		{
			return 0;
		}
		return StartRoutine(sCmdLine);
	}
	else if( _strcmpi(sCmdLine, "/RunService") == 0)
	{
		if(IsApplicationRunning())
		{
			return 0;
		}
		return StartRoutine(sCmdLine);
	}
	else if( _strcmpi(sCmdLine, "/OpenConsole") == 0)
    {
		if( IsServiceInstalled() == _No_ )
   		{
       		MessageBox(NULL, "The service is not installed.", gsTitleCaption, MB_ICONINFORMATION);
   			return 0;
        }

        if(IsServiceActive() == _No_)
        {
			if(IsApplicationRunning())
			{
				return 0;
			}

            if(MessageBox(NULL, "The service is not started. Would you like to start it now?",
				gsTitleCaption, MB_YESNO|MB_APPLMODAL|MB_ICONQUESTION) == IDNO)
            {
                return 0;
            }

    		if(StartService() == _Success_)
            {
        		//MessageBox(NULL, "The service was started sucessfully.", gsTitleCaption, MB_ICONINFORMATION);
            }
            else{
        		if(IsServerConfigured(false))
				{
					MessageBox(NULL, "Failed to start the service.", gsTitleCaption, MB_ICONINFORMATION);
				}
       			return 0;
            }
        }

        if(TriggerEvent(OpenServerConsoleEventName) != _Success_)
        {
            MessageBox(NULL, "Failed to modify service event state.", gsTitleCaption, MB_ICONINFORMATION);
        }

        return 0;
    }
    else if( _strcmpi(sCmdLine, "/OpenMainDialog") == 0)
    {
		if( IsServiceInstalled() == _No_ )
   		{
       		MessageBox(NULL, "The service is not installed.", gsTitleCaption, MB_ICONINFORMATION);
   			return 0;
        }

        if(IsServiceActive() == _No_)
        {
			if(IsApplicationRunning())
			{
				return 0;
			}

            if(MessageBox(NULL, "The service is not started. Would you like to start it now?",
				gsTitleCaption, MB_YESNO|MB_APPLMODAL|MB_ICONQUESTION) == IDNO)
            {
                return 0;
            }

    		if(StartService() == _Success_)
            {
    //    		MessageBox(NULL, "The service was started sucessfully.", gsTitleCaption, MB_ICONINFORMATION);
            }
            else{
        		MessageBox(NULL, "Failed to start the service.", gsTitleCaption, MB_ICONINFORMATION);
       			return 0;
            }
        }

        if(TriggerEvent(OpenMainDialogEventName) != _Success_)
        {
            MessageBox(NULL, "Failed to modify service event state.", gsTitleCaption, MB_ICONINFORMATION);
        }

        return 0;
    }
    else if( _strcmpi(sCmdLine, "/Install") == 0)
    {
        char Application[257];
		char sSrvcCmdLine[MAX_PATH];

    	short ServiceInstalled = IsServiceInstalled();

		if( ServiceInstalled == _Yes_ )
		{
    		//MessageBox(NULL, "The service is already installed.", gsTitleCaption, MB_ICONINFORMATION);
			return 0;
		}

		GetModuleFileName(ghAppInstance, Application, MAX_PATH);

		sprintf_s(sSrvcCmdLine, "%s /RunService", Application);

		if ( InstallService(sSrvcCmdLine) == _Success_ )
		{
			SetServiceDescription("Provides clients with secure high performance database replication over TCP/IP.");
			//MessageBox(NULL, "The service was installed sucessfully.", gsTitleCaption, MB_ICONINFORMATION);
			return 0;
		}
		else{
			MessageBox(NULL, "Failed to install the service.", gsTitleCaption, MB_ICONINFORMATION);
			return 0;
		}

        return 0;
    }
    else if( _strcmpi(sCmdLine, "/Start") == 0)
    {
		if(IsApplicationRunning())
		{
			return 0;
		}

		if( IsServiceInstalled() == _No_ )
		{
    		MessageBox(NULL, "The service is not installed.", gsTitleCaption, MB_ICONINFORMATION);
			return 0;
		}

        if(IsServiceActive() == _Yes_)
        {
//    		MessageBox(NULL, "The service is already active.", gsTitleCaption, MB_ICONINFORMATION );
			return 0;
        }

		if(StartService() == _Success_)
        {
//    		MessageBox(NULL, "The service was started sucessfully.", gsTitleCaption, MB_ICONINFORMATION );
            return 0;
        }
        else{
    		MessageBox(NULL, "Failed to start the service.", gsTitleCaption, MB_ICONINFORMATION);
   			return 0;
        }

        return 0;
    }
    else if( _strcmpi(sCmdLine, "/Delete") == 0)
    {
		if( IsServiceInstalled() == _No_ )
		{
//    		MessageBox(NULL, "The service is not installed.", gsTitleCaption, MB_ICONINFORMATION);
			return 0;
		}

        if(IsServiceActive() == _Yes_)
        {
            CommandService(SERVICE_CONTROL_STOP); // Failure would not be an error.
			return 0;
        }

    	if( UninstallService() == _Success_ )
    	{
//    		MessageBox(NULL, "The service was marked for deletion.", gsTitleCaption, MB_ICONINFORMATION);
    		return 0;
       	}
        else{
    		MessageBox(NULL, "Failed to mark the service for deletion.", gsTitleCaption, MB_ICONINFORMATION);
            return 0;
        }

        return 0;
    }
    else if( _strcmpi(sCmdLine, "/Stop") == 0)
    {
		if( IsServiceInstalled() == _No_ )
		{
//    		MessageBox(NULL, "The service is not installed.", gsTitleCaption, MB_ICONINFORMATION);
			return 0;
		}

        if(IsServiceActive() == _No_)
        {
//    		MessageBox(NULL, "The service is already stopped.", gsTitleCaption, MB_ICONINFORMATION);
			return 0;
        }

    	if( CommandService(SERVICE_CONTROL_STOP) == _Success_ )
    	{
//    		MessageBox(NULL, "The service was stopped.", gsTitleCaption, MB_ICONINFORMATION);
    		return 0;
       	}
        else{
    		MessageBox(NULL, "Failed to stop the service.", gsTitleCaption, MB_ICONINFORMATION);
            return 0;
        }
        return 0;
    }

	return 0;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int StartRoutine(char *sCmdLine)
{
	HANDLE MutexHandle = NULL;

	//-------------------------------------------------------------------------------
	SECURITY_DESCRIPTOR SD;
	SECURITY_ATTRIBUTES SA;

	if(InitializeSecurityDescriptor(&SD, SECURITY_DESCRIPTOR_REVISION) == FALSE)
		return _Error_;

	if(SetSecurityDescriptorDacl(&SD, TRUE, 0, FALSE) == FALSE)
		return _Error_;

	SA.nLength				= sizeof(SA);
	SA.lpSecurityDescriptor = &SD;
	SA.bInheritHandle		= FALSE;
	
	char sMutexName[1024];
	if((MutexHandle = CreateMutex(&SA, FALSE, GetBuildMutexName(gsTitleCaption, sizeof(sMutexName), sMutexName))) != 0)
	{
		if(GetLastError() == ERROR_ALREADY_EXISTS)
		{
			MessageBox(NULL, "Application already running.", gsTitleCaption, MB_SYSTEMMODAL + MB_TASKMODAL);
			return _Error_;
		}
	}

	if(!IsServerConfigured(true))
	{
		return false;
	}

	if(_strcmpi(sCmdLine, "/RunService") == 0)
	{
		int Length		   = 0;
		short Result	   = 0;
		//-------------------------------------------------------------------------------

		Result = ServiceEntry();

		if(Result == _Success_)
		{
			return(_Success_);
		}
		else if(Result == _Error_)
		{
			return(_Error_);
		}
	}
	else{
		hServiceThread_Handle = CreateThread(NULL, 0, ServiceThread, (LPVOID)0, 0, &dwServiceThread_ID);
		//Sleep(1000);
		DialogBox(ghAppInstance, MAKEINTRESOURCE(IDD_MAIN), 0, (DLGPROC)MainDialog);
		WaitOnApplicationToExit();
		return _Success_;
	}

	return _Error_;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool MainEntry(void)
{
    gbApplicationRunning = true;

	WriteSysLogEx("Service started.", EVENT_INFO);

	if(gbStartAutomatically)
	{
		if(!StartServer())
		{
			gbApplicationRunning = false;
			return false;
		}
	}
	else WriteSysLogEx("Server is not set to start automatically.", EVENT_INFO);

	int iStatCount = 10000;

	while(!gbKillApplication)
    {
		if(WaitForSingleObject(hOpenMainDialog_Handle, 0) == WAIT_OBJECT_0)
        {
			DialogBox(ghAppInstance, MAKEINTRESOURCE(IDD_MAIN), NULL, (DLGPROC)MainDialog);
        }

    	if(WaitForSingleObject(hOpenConsole_Handle, 0) == WAIT_OBJECT_0)
        {
			if(gbConsoleOpen)
				CloseConsole();
			else OpenConsole();
        }

		if(iStatCount > 1000)
		{
			UpdateStatistics();
			iStatCount = 0;
		}

		iStatCount++;

		Sleep(1);
    }
	WriteSysLogEx("Service Stopped.", EVENT_INFO);

	if(gServer.cbActive)
	{
		if(!StopServer())
		{
		    gbApplicationRunning = false;
			return false;
		}
	}

    gbApplicationRunning = false;
    return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
